#ifndef __DRV_VRS_CFG_H_
#define __DRV_VRS_CFG_H_

#include "TLR_Includes.h"



/**************************************************************************************
 * IN/OUT/MIX mode setup parameters and MAC IDs
 *************************************************************************************/ 
#define VRS_MAC_WORD_IN_MIX_SLAVE_START       (0)
#define VRS_MAC_WORD_IN_MIX_SLAVE_END         (63)
#define VRS_MAC_WORD_OUT_SLAVE_START          (64)
#define VRS_MAC_WORD_OUT_SLAVE_END            (127)
#define VRS_MAC_BIT_IN_MIX_SLAVE_START        (128)
#define VRS_MAC_BIT_IN_MIX_SLAVE_END          (255)
#define VRS_MAC_BIT_OUT_SLAVE_START           (256)
#define VRS_MAC_BIT_OUT_SLAVE_END             (383)
#define VRS_MAC_REPEATER_START                (384)
#define VRS_MAC_REPEATER_END                  (447)
#define VRS_MAC_MASTER                        (448)
#define VRS_MAC_RESERVED_START                (449)
#define VRS_MAC_RESERVED_END                  (511) 

typedef struct DRV_VRS_INIT_PARAM_Ttag{
  unsigned int ulDummy;
}DRV_VRS_INIT_PARAM_T;

typedef struct DRV_CONFIG_SET_Ttag{
  char szXPec[16];
  char szXRpu[16];
  char szXTpu[16];
  char szIrq[16];
  unsigned int ulXcPort;
}DRV_CONFIG_SET_T;

typedef struct DRV_RESOURCES_Ttag{
  DRV_CONFIG_SET_T *ptLoc;
  void *pvRem;
}DRV_RESOURCES_T;

typedef struct DRV_CONFIG_XC_Ttag{
  RX_HANDLE hxPec;
  RX_HANDLE hxMacRpu;
  RX_HANDLE hxMacTpu;
  RX_HANDLE hIrqId;
  void(*pfEventCallback)(RX_HANDLE , void*); 
  DRV_RESOURCES_T tRsc;
}DRV_CONFIG_XC_T;


RX_FATAL  Drv_VaranClientInitConfigSet(void *pvPrm, unsigned int ulSize);
RX_RESULT Drv_VaranClientInitialize(void *pfnProcIrq, void *pfnSyncIrq, void *pfnMsSync, void *pvPrm);
RX_RESULT Drv_VaranClientXcIrqEnable(TLR_BOOLEAN fEnable);
RX_RESULT Drv_VaranClientXcIrqEnableMsync(TLR_BOOLEAN fEnable);
RX_RESULT Drv_VaranClientXcIrqUnInit(void);
TLR_VOID  Drv_VaranClientXCsEnable(TLR_BOOLEAN fIsEnabled);

TLR_RESULT Drv_DualPhyReInitialize(TLR_VOID);


#endif



